@extends('layouts.app')


@section('content')
    <div class="row">
        <div class="col-lg-12 margin-tb">
            <div class="pull-left">
                <h2>dashboard</h2>
            </div>
            <div class="pull-right">
                @can('dashboard-create')
                <a class="btn btn-success" href="{{ route('dashboard.create') }}"> Create New dashboard</a>
                @endcan
            </div>
        </div>
    </div>


    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif


    <table class="table table-bordered">
        <tr>
            <th>No</th>
            <th>Name</th>
            <th>Details</th>
            <th width="280px">Action</th>
        </tr>
	    @foreach ($dashboard as $dashboard)
	    <tr>
	        <td>{{ ++$i }}</td>
	        <td>{{ $dashboard->name }}</td>
	        <td>{{ $dashboard->detail }}</td>
	        <td>
                <form action="{{ route('dashboard.destroy',$dashboard->id) }}" method="POST">
                    <a class="btn btn-info" href="{{ route('dashboard.show',$dashboard->id) }}">Show</a>
                    @can('dashboard-edit')
                    <a class="btn btn-primary" href="{{ route('dashboard.edit',$dashboard->id) }}">Edit</a>
                    @endcan


                    @csrf
                    @method('DELETE')
                    @can('dashboard-delete')
                    <button type="submit" class="btn btn-danger">Delete</button>
                    @endcan
                </form>
	        </td>
	    </tr>
	    @endforeach
    </table>


    {!! $dashboard->links() !!}


<p class="text-center text-primary"><small>Tutorial by ItSolutionStuff.com</small></p>
@endsection