<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Perfil;
use Illuminate\Support\Facades\Auth;

class ProfileController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $perfil = Perfil::where('users_id',Auth::id())->first();
        
        return view('profile.index',compact('perfil'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $perfil = Perfil::where('users_id',Auth::id())->count();

        $this->validate($request, [
            'nome' => 'required',
            'cargo' => 'required',
            'dtnascimento' => 'required',
            'sexo' => 'required',
            'telefone' => 'required',
            'logradouro' => 'required',
            'numero' => 'required',
            'cidade' => 'required',
            'uf' => 'required',
            'avatar' => 'image',
            'cep' => 'required'
        ]);
        
        $request['users_id'] = Auth::id();
        $avatarr = $request['avatar'];
        
        $data = $request->all();
        unset($data['avatar']);
 
        if($perfil == 0){
            //Gravar novo
            $perfil = Perfil::create($data);
            
        }else{
            //editar existente
            unset($request['_token']);
            unset($request['email']);
            $data = $request->all();
            unset($data['avatar']);
            $perfil = Perfil::where('users_id',Auth::id());
            $perfil->update($data);
        }

        if(!is_null($avatarr)){
            $avatarName = time().'.'.$request->avatar->getClientOriginalExtension();
            $request->avatar->move(public_path('avatars'), $avatarName);      
            Auth::user()->update(['avatar'=>$avatarName]);
        }
        return back()->with('success', 'Avatar updated successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
