<?php

namespace App\Http\Controllers;

use App\Models\Dashboard;
use Illuminate\Http\Request;

class DashboardController extends Controller
{

    function __construct()
    {
         $this->middleware('permission:dashboard-list|dashboard-create|dashboard-edit|dashboard-delete', ['only' => ['index','show']]);
         $this->middleware('permission:dashboard-create', ['only' => ['create','store']]);
         $this->middleware('permission:dashboard-edit', ['only' => ['edit','update']]);
         $this->middleware('permission:dashboard-delete', ['only' => ['destroy']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $dashboards = Dashboard::latest()->paginate(5);
        return view('dashboards.index',compact('dashboards'))
            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('dashboards.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'nome' => 'required',
            'detalhe' => 'required',
            'link' => 'required',
        ]);
    
        Dashboard::create($request->all());
    
        return redirect()->route('dashboard.index')
                        ->with('success','Dashboard created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show( Dashboard $dashboard)
    {
        return view('dashboards.show',compact('dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Dashboard $dashboard)
    {
        return view('dashboards.edit',compact('dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Dashboard $dashboard)
    {
        request()->validate([
            'nome' => 'required',
            'detalhe' => 'required',
            'link' => 'required',
        ]);
    
        $dashboard->update($request->all());
    
        return redirect()->route('dashboards.index')
                        ->with('success','Dashboard updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Dashboard $dashboard)
    {
        $dashboard->delete();
    
        return redirect()->route('dashboards.index')
                        ->with('success','Dashboard deleted successfully');
    }
}
